# (from https://github.com/BlueBrain/spack)

# Copyright 2013-2024 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack.package import *


class PyBluepymm(PythonPackage):
    """Blue Brain Model Management Python Library"""

    homepage = "https://github.com/BlueBrain/BluePyMM"
    pypi = "bluepymm/bluepymm-0.7.49.tar.gz"

    version("0.7.65", sha256="024b009decd8d967b3b885421196d53670e3c0a6b75aaaa55559f148b0b0d7d4")

    depends_on("py-setuptools", type="build")
    depends_on("py-bluepyopt", type="run")
    depends_on("py-matplotlib", type="run")
    # The below dependency should disappear once
    # the matplotlib package is fixed
    # not needed with EBRAINS python version:
    # depends_on("py-backports-functools-lru-cache", type="run", when="^python@:3.3.99")
    depends_on("py-pandas", type="run")
    depends_on("py-numpy", type="run")
    depends_on("py-ipyparallel", type="run")
    depends_on("py-lxml", type="run")
    depends_on("py-sh", type="run")
    depends_on("neuron", type="run")
    depends_on("py-h5py", type="run")
    depends_on("py-pyyaml", type="run")

    def setup_run_environment(self, env):
        env.unset("PMI_RANK")
        env.set("NEURON_INIT_MPI", "0")
