#!/usr/bin/env python
# encoding:utf8
"""
Filter to modify `setenv` statements in modulefiles to `prepend-path` statements.

Usage:
    tools/ensure_prepend.py PATH MANPATH PYTHONPATH <../build.52.VGk/test.mod
or
    module sh-to-mod bash somescript.sh | ensure_prepend.py PATH MANPATH PYTHONPATH > path/to/module
"""

import logging
import os
import re
import sys

logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger()

def main():
    names = sys.argv[1:]
    log.debug("rewriting %s", names)

    bad_re = re.compile(r'^setenv\s+(?P<varname>[a-zA-Z_0-9]+)\s+(?P<value>.*)')
    for line in sys.stdin:
        match = bad_re.match(line)
        if not match or match.group('varname') not in names:
            print(line, end='')
            continue
        log.debug("found bad line: %s", line.rstrip("\n"))
        name = match.group("varname")
        log.debug("name %s", name)
        value = match.group("value")
        log.debug("value %s", value)
        parts = value.split(":")
        log.debug("parts %s", parts)
        have = os.environ.get(name, "").split(':')
        log.debug("have %s", have)

        print(f"prepend-path    {name} " + ":".join([p for p in parts if p not in have]))


if __name__ == '__main__':
    main()
